/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1;

import com.roguewave.chart.core.v2_1.ChartBuilder;
import com.roguewave.chart.core.v2_1.ChartGraphics;
import com.roguewave.chart.core.v2_1.ChartPart;
import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.Customizer;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.SortTreeInternal;
import com.roguewave.chart.core.v2_1.graphics.SortTreeLeaf;
import com.roguewave.chart.core.v2_1.graphics.SortTreeNode;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.standard.v2_1.parts.BinGrid;
import com.roguewave.chart.standard.v2_1.parts.BinScale;
import com.roguewave.chart.standard.v2_1.parts.NumericGrid;
import com.roguewave.chart.standard.v2_1.parts.NumericScale;
import com.roguewave.chart.standard.v2_1.parts.Platform;
import com.roguewave.chart.standard.v2_1.parts.RescalerDrawable;
import com.roguewave.chart.standard.v2_1.parts.Scale;
import com.roguewave.chart.standard.v2_1.parts.Spacer;
import java.awt.Font;

public abstract class BarChartBase
implements ChartBuilder {
    private static final double defaultBasePad = 0.25;
    private static final double defaultBaseHeight = 0.5;
    private static final boolean use3DFontByDefault = true;

    protected abstract ChartPart makePart(ChartProperties var1, DataModel var2, int var3, Transform3D var4, int var5);

    protected abstract int chartRows(int var1);

    public boolean supports(int viewMode) {
        switch (viewMode) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public ChartGraphics build(ChartProperties properties, DataModel data) {
        Point3D[] testPoints;
        long start = System.currentTimeMillis();
        double basePad = properties.getProperty("BasePad", 0.25);
        double baseHeight = properties.getProperty("PlatformHeight", 0.5);
        boolean vertical = (Boolean)properties.getProperty("ChartOrientation", new Boolean(true));
        int shading = vertical ? 22 : 38;
        boolean use3DFont = (Boolean)properties.getProperty("useTrue3DFonts", new Boolean(true));
        Transform3D zRot8 = vertical ? new Transform3D() : Transform3D.rotateZNeg90Degrees();
        ChartGraphics chartGraphics = new ChartGraphics();
        Customizer customizer = properties.get2DStyleCustomizer();
        if (customizer != null) {
            chartGraphics.add2DDrawable(customizer.getDrawable(properties, data));
        }
        if ((customizer = properties.get3DStyleCustomizer()) != null) {
            chartGraphics.add3DDrawable(customizer.getDrawable(properties, data));
        }
        int rows = data.getRowCount();
        int columns = data.getColumnCount();
        ChartPart[] parts = new ChartPart[columns];
        chartGraphics.setParts(parts);
        double baseDepth = (double)this.chartRows(rows) + (double)2 * basePad;
        double baseFrontZ = -baseDepth / 2.0;
        double baseBackZ = baseDepth / 2.0;
        double columnX = (double)(-columns) / 2.0;
        for (int column = 0; column < columns; ++column) {
            Transform3D trans = Transform3D.translate(columnX, 0.0, 0.0);
            trans = new Transform3D(zRot8, trans);
            parts[column] = this.makePart(properties, data, column, trans, shading);
            columnX += 1.0;
        }
        double scaleIncrement = 10.0;
        double range = properties.getDataRangeHigh() - properties.getDataRangeLow();
        while (range / scaleIncrement > (double)10) {
            scaleIncrement *= (double)10;
        }
        while (range / scaleIncrement < (double)5) {
            scaleIncrement /= (double)2;
        }
        scaleIncrement = properties.getProperty("ScaleIncrement", scaleIncrement);
        double lowLine = (double)((int)(properties.getDataRangeLow() / scaleIncrement)) * scaleIncrement;
        if (properties.scaleY(lowLine) < 0.0) {
            lowLine += scaleIncrement;
        }
        Spacer spacer = new Spacer(properties, lowLine, scaleIncrement);
        boolean isMultiRow = this.chartRows(rows) != 1;
        Customizer platform = new Platform(isMultiRow);
        platform = (Customizer)properties.getProperty("3DPlatform", platform);
        Drawable platformDrawable = platform.getDrawable(properties, data);
        SortTreeLeaf stlPlatform = new SortTreeLeaf();
        stlPlatform.addDrawable(platformDrawable);
        double halfWidth = (double)columns / 2.0;
        Point3D end1 = new Point3D(-halfWidth, 0.0, baseFrontZ);
        boolean sideAlign = !vertical;
        boolean drawTicks = true;
        BinScale binScale = new BinScale(columns, 0.0, vertical, drawTicks);
        Customizer bottomScale = (Customizer)properties.getProperty("BottomScale", binScale);
        Drawable bscale = bottomScale.getDrawable(properties, data);
        double scaleWidth = 0.5;
        double scaleHeight = 0.5;
        Scale leftScale = null;
        Font bottomScaleFont = null;
        if (bottomScale instanceof Scale) {
            if (!vertical) {
                leftScale = (Scale)((Object)bottomScale);
                scaleWidth = 0.0;
                scaleHeight = 0.0;
            } else {
                bottomScaleFont = ((Scale)((Object)bottomScale)).getFont();
                scaleHeight = bottomScale instanceof BinScale ? ((BinScale)bottomScale).getScalableHeight() : 0.0;
            }
        }
        chartGraphics.add2DDrawable(bscale);
        SortTreeLeaf backDropNode = new SortTreeLeaf();
        Transform3D trans = new Transform3D(Transform3D.translate(0.0, 0.0, baseBackZ), zRot8);
        NumericGrid numericGrid = new NumericGrid(lowLine, scaleIncrement, trans);
        Drawable grid = numericGrid.getDrawable(properties, data);
        backDropNode.addDrawable(grid);
        chartGraphics.add2DDrawable(grid);
        Customizer scale = new NumericScale(columns, lowLine, scaleIncrement, vertical);
        scale = (Customizer)properties.getProperty("2DLeftScale", scale);
        chartGraphics.add2DDrawable(scale.getDrawable(properties, data));
        if (scale instanceof Scale && vertical) {
            leftScale = (Scale)((Object)scale);
            scaleWidth = 0.0;
        }
        if ((scale = (Customizer)properties.getProperty("2DRightScale", null)) != null) {
            chartGraphics.add2DDrawable(scale.getDrawable(properties, data));
        }
        int rightScaleAlignment = vertical ? 2 : 0;
        Point3D lowRight = new Point3D(halfWidth, 0.0, vertical ? baseBackZ : baseFrontZ);
        double z = vertical ? baseBackZ : baseFrontZ;
        scale = new NumericScale(columns, lowLine, scaleIncrement, z, use3DFont, vertical);
        scale = (Customizer)properties.getProperty("3DRightScale", scale);
        Drawable rightScale = scale.getDrawable(properties, data);
        if (vertical && scale != null) {
            backDropNode.addDrawable(rightScale);
        }
        if ((scale = (Customizer)properties.getProperty("3DLeftScale", null)) != null) {
            backDropNode.addDrawable(scale.getDrawable(properties, data));
        }
        Drawable rightGrid = null;
        if (!vertical) {
            stlPlatform = new SortTreeLeaf();
            boolean ticks = false;
            binScale = new BinScale(columns, baseFrontZ, vertical, ticks, use3DFont);
            bottomScale = (Customizer)properties.getProperty("BottomScale", binScale);
            stlPlatform.addDrawable(bottomScale.getDrawable(properties, data));
            BinGrid binGrid = new BinGrid(this.chartRows(rows) != 1, basePad, 0.0, zRot8);
            stlPlatform.addDrawable(binGrid.getDrawable(properties, data));
            Transform3D rot8s = new Transform3D(Transform3D.rotateX(-90.0), zRot8);
            Transform3D rotNTrans = new Transform3D(Transform3D.translate(0.0, (double)(-columns) / 2.0, 0.0), rot8s);
            NumericGrid bottomGrid = new NumericGrid(lowLine, scaleIncrement, baseDepth, rotNTrans);
            rightGrid = bottomGrid.getDrawable(properties, data);
        }
        columnX = (double)(-columns) / 2.0 + 1.0;
        SortTreeNode barColumns = parts[0].getSortTree();
        for (int i = 1; i < columns; ++i) {
            testPoints = new Point3D[]{zRot8.transform(new Point3D(columnX, 0.0, 0.0)), zRot8.transform(new Point3D(columnX, 0.0, 1.0)), zRot8.transform(new Point3D(columnX, 1.0, 1.0))};
            barColumns = new SortTreeInternal(barColumns, parts[i].getSortTree(), testPoints);
            columnX += 1.0;
        }
        testPoints = new Point3D[]{zRot8.transform(new Point3D(0.0, 0.0, baseBackZ)), zRot8.transform(new Point3D(0.0, 1.0, baseBackZ)), zRot8.transform(new Point3D(1.0, 0.0, baseBackZ))};
        SortTreeInternal stn = new SortTreeInternal(barColumns, backDropNode, testPoints);
        if (rightGrid != null) {
            testPoints = new Point3D[]{zRot8.transform(new Point3D((double)columns / 2.0, 0.0, 0.0)), zRot8.transform(new Point3D((double)columns / 2.0, 0.0, 1.0)), zRot8.transform(new Point3D((double)columns / 2.0, 1.0, 1.0))};
            SortTreeLeaf rightGridNode = new SortTreeLeaf();
            rightGridNode.addDrawable(rightGrid);
            if (!vertical && rightScale != null) {
                rightGridNode.addDrawable(rightScale);
            }
            stn = new SortTreeInternal(stn, rightGridNode, testPoints);
        }
        testPoints = new Point3D[]{zRot8.transform(new Point3D(0.0, 0.0, 0.0)), zRot8.transform(new Point3D(1.0, 0.0, 0.0)), zRot8.transform(new Point3D(0.0, 0.0, 1.0))};
        chartGraphics.setSortTree(new SortTreeInternal(stlPlatform, stn, testPoints));
        Point3D[] bounds = this.get2DBoundingBox(properties, data, vertical, spacer, scaleWidth, scaleHeight);
        for (int i = 0; i < bounds.length; ++i) {
            bounds[i] = zRot8.transform(bounds[i]);
        }
        chartGraphics.setBounds2D(bounds);
        if (leftScale != null) {
            String[] leftScaleStrings = leftScale.getStrings();
            Font leftScaleFont = leftScale.getFont();
            chartGraphics.setRescaler(new RescalerDrawable(leftScaleStrings, leftScaleFont, bounds));
        } else if (bottomScaleFont != null) {
            chartGraphics.setRescaler(new RescalerDrawable(bottomScaleFont, bounds));
        }
        bounds = this.get3DBoundingBox(properties, data, spacer);
        for (int i = 0; i < bounds.length; ++i) {
            bounds[i] = zRot8.transform(bounds[i]);
        }
        chartGraphics.setBounds3D(bounds);
        long end = System.currentTimeMillis();
        return chartGraphics;
    }

    Point3D[] get3DBoundingBox(ChartProperties properties, DataModel data, Spacer spacer) {
        int rows = data.getRowCount();
        int columns = data.getColumnCount();
        double basePad = properties.getProperty("BasePad", 0.25);
        double baseHeight = properties.getProperty("PlatformHeight", 0.5);
        double baseDepth = (double)this.chartRows(rows) + (double)2 * basePad;
        double baseFrontZ = -baseDepth / 2.0;
        double baseBackZ = baseDepth / 2.0;
        int numIncrements = spacer.valueCount();
        double gridMax = properties.scaleY(spacer.getValue(numIncrements - 1));
        double backScaleWidth = 1.0;
        double frontScaleWidth = 0.0;
        if (!properties.getProperty("ChartOrientation", true)) {
            backScaleWidth = 0.0;
            frontScaleWidth = 1.0;
            gridMax += 0.5;
        }
        double left = (double)(-columns) / 2.0;
        double right = (double)columns / 2.0;
        double bottom = -baseHeight;
        double top = properties.getChartHeight();
        if (gridMax > top) {
            top = gridMax;
        }
        double front = baseFrontZ;
        double back = baseBackZ;
        Point3D[] points = new Point3D[]{new Point3D(left, bottom, front), new Point3D(left, bottom, back), new Point3D(left, top += 0.2, back), new Point3D(left, top, front), new Point3D(right + frontScaleWidth, bottom, front), new Point3D(right + backScaleWidth, bottom, back), new Point3D(right + backScaleWidth, top, back), new Point3D(right + frontScaleWidth, top, front)};
        return points;
    }

    Point3D[] get2DBoundingBox(ChartProperties properties, DataModel data, boolean isVertical, Spacer spacer, double scaleWidth, double scaleHeight) {
        int rows = data.getRowCount();
        int columns = data.getColumnCount();
        int numIncrements = spacer.valueCount();
        double gridMax = properties.scaleY(spacer.getValue(numIncrements - 1));
        double left = (double)(-columns) / 2.0 - scaleWidth;
        double right = (double)columns / 2.0;
        if (isVertical) {
            right += scaleHeight;
        } else {
            gridMax += 0.5;
        }
        double bottom = -scaleHeight;
        double top = properties.getChartHeight();
        if (gridMax > top) {
            top = gridMax;
        }
        Point3D[] points = new Point3D[]{new Point3D(left, bottom, 0.0), new Point3D(left, top, 0.0), new Point3D(right, bottom, 0.0), new Point3D(right, top, 0.0)};
        return points;
    }
}

